﻿Imports System.Collections.Generic
Imports System.Collections.Specialized
Imports System.IO
Imports System.Net
Imports System.Runtime.Serialization
Imports Newtonsoft.Json
Imports System.Text
Imports System.Web
Imports System.Runtime.Serialization.Json
Imports Newtonsoft.Json.Linq

Public Class Form1
    ''' <summary>
    ''' ExecuteImportXML
    ''' Submits the import request to the web service. This sample app doesn't make use of sender or e (EventArgs).
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub Button1_Click(sender As Object, e As EventArgs) Handles Button1.Click
        If Not String.IsNullOrEmpty(TextBox_filename.Text) Then
            Dim baseUri As String = TextBox_uri.Text
            Dim filePath As String = TextBox_filepath.Text
            Dim desc As String = TextBox_description.Text
            Dim filename As String = TextBox_filename.Text
            Dim importType As String = ComboBox_ImportType.SelectedValue
            Dim entityId As String = TextBox_entityid.Text
            Dim repeat As Integer = 0
            If txtMetricsRepeat.Text IsNot Nothing Then
                Integer.TryParse(txtImportRepeat.Text, repeat)
            End If

            ExecuteImportXML(baseUri, filePath, filename, desc, importType, entityId, repeat)
        Else
            AddStatus("ERROR", "Please fill in all fields")
        End If
    End Sub

    Private Sub ExecuteImportXML(ByVal baseUri As String, ByVal filePath As String, ByVal filename As String, ByVal desc As String,
                                 ByVal importType As String, ByVal entityId As String, ByVal repeat As Integer)
        Dim callProcessOneMoreTime As Boolean = False
        Dim client As WebClient = New WebClient()
        For index = 0 To repeat
            ' Build the uri and queryString from the form values.

            'if we're doing repeated requests, increment some values to make them distinct
            If repeat > 0 Then
                desc = desc & index.ToString
                filename = filename & index.ToString
            End If

            ' ContentType will always be "text/xml"
            Dim queryString As String = String.Format("importxml?filename={0}&desc={1}&ct={2}&it={3}&eid={4}",
                                                    filename,
                                                    desc,
                                                    "text/xml",
                                                    importType,
                                                    entityId)
            Dim theUri As Uri = New Uri(baseUri & queryString)
            AddStatus("URI: ", theUri.ToString)
            Dim xmlFileData As Byte()
            If IO.File.Exists(filePath) Then
                xmlFileData = IO.File.ReadAllBytes(filePath)
                Try
                    ' Use the current user's credentials for authorization (the same credentials that XFRACAS requires for auth).
                    client.Credentials = System.Net.CredentialCache.DefaultCredentials

                    ' The call to the service
                    Dim response As Byte() = client.UploadData(theUri, xmlFileData)

                    ' The response is a JSON encoded dictionary similar to:
                    '
                    '{
                    '    "result"{
                    '        "ID":"89cfd7e6-b8cb-4bb1-b093-0575b4409e8d"
                    '    },
                    '    "status":1,
                    '    "message":""
                    '}
                    '
                    Dim responseString As String = System.Text.Encoding.ASCII.GetString(response)

                    ' Get the "result" dictionary out of the JSON response
                    Dim responseDict As JObject = JsonConvert.DeserializeObject(responseString)
                    Dim resultDict As Dictionary(Of String, String) = responseDict.Item("result").ToObject(Of Dictionary(Of String, String))

                    ' Get the "ID" value out of "result"
                    Dim importID As String = resultDict.Item("ID")

                    If responseString.Contains("ERROR") Then
                        AddStatus("ERROR", responseString)
                    Else
                        AddStatus("Response:", responseString)
                    End If
                Catch ex As Exception
                    ' Possible exception causes: authorization failed, host not reachable, etc.
                    AddStatus("ERROR", ex.Message)
                End Try
            End If

            ' Optional: call ProcessImports every 10 records to cause the data to import.
            'If index Mod 10 = 0 Then
            '    ExecuteProcess(client)
            'Else
            '    callProcessOneMoreTime = True
            'End If
        Next

        ' Optional: if there's anything left to process, do it now
        'If callProcessOneMoreTime Then
        '    ExecuteGetRequest("ProcessImports")
        'End If
    End Sub

    Private Sub Button_choosefile_Click(sender As Object, e As EventArgs) Handles Button_choosefile.Click
        Dim openDialog As OpenFileDialog = New OpenFileDialog()
        openDialog.Filter = "XML files (*.xml)|*.xml"
        If openDialog.ShowDialog() = Windows.Forms.DialogResult.OK Then
            Dim filePath As String = openDialog.FileName()
            TextBox_filepath.Text = filePath
        End If
    End Sub

    ''' <summary>
    ''' Initializes the list of supported import types. The values in the dictionary are the important
    ''' bits, as those are the supported values (1-13).
    ''' </summary>
    Private Sub SetupImportTypes()
        Dim importTypeList As New List(Of DictionaryEntry)
        importTypeList.Add(New DictionaryEntry("Incident", "1"))
        importTypeList.Add(New DictionaryEntry("Problem", "2"))
        importTypeList.Add(New DictionaryEntry("Unit Commissioning", "3"))
        importTypeList.Add(New DictionaryEntry("Failure Analysis", "4"))
        importTypeList.Add(New DictionaryEntry("Project", "5"))
        importTypeList.Add(New DictionaryEntry("Issue", "6"))
        importTypeList.Add(New DictionaryEntry("User", "7"))
        importTypeList.Add(New DictionaryEntry("Address", "8"))
        importTypeList.Add(New DictionaryEntry("Company", "9"))
        importTypeList.Add(New DictionaryEntry("Action", "10"))
        importTypeList.Add(New DictionaryEntry("System", "12"))
        importTypeList.Add(New DictionaryEntry("MasterBOM", "13"))
        ComboBox_ImportType.DataSource = importTypeList
    End Sub

    Private Sub Form1_Load(sender As Object, e As EventArgs) Handles Me.Load
        ' Load the list of supported types
        SetupImportTypes()
    End Sub

    Private Sub AddStatus(ByVal key As String, ByVal newStatusLine As String)
        ' Adds a status to the bottom of the status text field
        txt_status.AppendText(key & Environment.NewLine & "    " & newStatusLine & Environment.NewLine)
    End Sub

    ''' <summary>
    ''' ProcessImports
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub button_process_Click(sender As Object, e As EventArgs) Handles button_process.Click
        ' Call ProcessImports in the service, which doesn't return anything. We'll at least update
        ' the status log to indicate we did something.
        Dim eid As Integer
        If Not String.IsNullOrWhiteSpace(txtProcessEntityID.Text) Then
            eid = Integer.Parse(txtProcessEntityID.Text)
        End If

        ExecuteGetRequest("processimports", "?eid=" & eid)
    End Sub

    Private Sub ExecuteGetRequest(ByVal method As String, Optional ByVal queryString As String = "")
        Try
            Dim client As WebClient = New WebClient()
            Dim theUri As Uri = New Uri(TextBox_uri.Text & method & queryString)
            AddStatus("URI: ", theUri.ToString)
            client.Credentials = System.Net.CredentialCache.DefaultCredentials
            Dim response As String = client.DownloadString(theUri)
            AddStatus("Response: ", response)
        Catch ex As Exception
            AddStatus("ERROR: ", ex.Message)
        End Try
    End Sub

    Private Sub ImportMetrics_Click(sender As Object, e As EventArgs) Handles Button2.Click
        If Not String.IsNullOrEmpty(txtPartName.Text) Then
            ' Build the uri and queryString from the form values.
            Dim client As WebClient = New WebClient()

            ' Repeat is used to test submitting several items in a row
            Dim repeat As Integer = 0
            If txtMetricsRepeat.Text IsNot Nothing Then
                Integer.TryParse(txtMetricsRepeat.Text, repeat)
            End If
            For index = 0 To repeat
                ' For the repeating test, we're simulating importing one value per metric per day.
                Dim md As Date = Date.Parse(txtMDate.Text)

                md = md.AddDays(index)
                Dim m1 As Integer
                If Not String.IsNullOrWhiteSpace(txtM1.Text) Then
                    m1 = Integer.Parse(txtM1.Text) + index
                End If
                Dim m2 As Integer
                If Not String.IsNullOrWhiteSpace(txtM2.Text) Then
                    m2 = Integer.Parse(txtM2.Text) + index
                End If
                Dim m3 As Integer
                If Not String.IsNullOrWhiteSpace(txtM3.Text) Then
                    m3 = Integer.Parse(txtM3.Text) + index
                End If
                Dim eid As Integer
                If Not String.IsNullOrWhiteSpace(txtMetricsEntityID.Text) Then
                    eid = Integer.Parse(txtMetricsEntityID.Text)
                End If

                ' pName is Part Name
                ' pNumber is Part Number
                ' sn is Serial Number
                ' m1 - m3 are Time Metric 1 - 3
                ' md is Metric Date (formatted per ISO8601 standard)
                ' eid is Entity ID
                Dim queryString As String = String.Format("importmetrics?pname={0}&pnumber={1}&sn={2}&m1={3}&m2={4}&m3={5}&md={6}&eid={7}",
                                                    txtPartName.Text,
                                                    txtPartNumber.Text,
                                                    txtSerialNumber.Text,
                                                    m1.ToString,
                                                    m2.ToString,
                                                    m3.ToString,
                                                    md.ToString("s", System.Globalization.CultureInfo.InvariantCulture),
                                                    eid.ToString)

                Dim theUri As Uri = New Uri(TextBox_uri.Text & queryString)
                AddStatus("URI: ", theUri.ToString)
                Try
                    ' Use the current user's credentials for authorization (the same credentials that XFRACAS requires for auth).
                    client.Credentials = System.Net.CredentialCache.DefaultCredentials
                    ' The call to the service, which returns a status or error
                    Dim response As String = client.UploadString(theUri, "test")
                    AddStatus("Response: ", response)
                Catch ex As Exception
                    ' Possible exception causes: authorization failed, host not reachable, etc.
                    AddStatus("ERROR: ", ex.Message)
                End Try

            Next
        Else
            AddStatus("ERROR", "Please fill in all fields")
        End If


    End Sub

    ''' <summary>
    ''' GetAllXFRACASEntities
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub GetEntities_Click(sender As Object, e As EventArgs) Handles Button3.Click
        ExecuteGetRequest("entities")
    End Sub

    Private Function GenerateException() As NullReferenceException
        Try
            Dim array As List(Of String) = Nothing
            Dim int As Integer = array.Count()
        Catch ex As NullReferenceException
            Return ex
        End Try
        Return Nothing
    End Function

    ''' <summary>
    ''' WriteExceptionToDiagnosticsLog
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub LogException_Click(sender As Object, e As EventArgs) Handles Button4.Click
        Dim client As WebClient = New WebClient()

        ' Generate an Exception that we can send to the service.
        Dim ex As NullReferenceException = GenerateException()

        Dim ser As New DataContractJsonSerializer(GetType(NullReferenceException))
        Dim s As New MemoryStream()
        ser.WriteObject(s, ex)

        ' JSON string representation of the exception, which will become the payload for UploadString
        Dim exString As String = Encoding.ASCII.GetString(s.ToArray())

        ' et is the type (1 = Error, 2 = Warning, 4 = Information)
        ' c is a text comment
        Dim queryString As String = String.Format("logexc?et=2&c=testcomment")

        Dim theUri As Uri = New Uri(TextBox_uri.Text & queryString)
        AddStatus("URI: ", theUri.ToString)
        Try
            ' Use the current user's credentials for authorization (the same credentials that XFRACAS requires for auth).
            client.Credentials = System.Net.CredentialCache.DefaultCredentials
            client.Headers.Add(HttpRequestHeader.ContentType, "text/json")
            Dim response As String = client.UploadString(theUri, exString)
            ' WriteExceptionToDiagnosticsLog returns the string "Success" as its result.
            AddStatus("Response: ", response)
        Catch requestEx As Exception
            ' Possible exception causes: authorization failed, host not reachable, etc.
            AddStatus("ERROR: ", requestEx.Message)
        End Try

    End Sub

    ''' <summary>
    ''' WriteMessageToDiagnosticsLog
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub LogMessage_Click(sender As Object, e As EventArgs) Handles Button5.Click
        Dim client As WebClient = New WebClient()

        ' m is the message
        ' et is the type (1 = Error, 2 = Warning, 4 = Information)
        Dim queryString As String = String.Format("logmsg?m={0}&et=2", txtMessage.Text)

        Dim theUri As Uri = New Uri(TextBox_uri.Text & queryString)
        AddStatus("URI: ", theUri.ToString)
        Try
            ' Use the current user's credentials for authorization (the same credentials that XFRACAS requires for auth).
            client.Credentials = System.Net.CredentialCache.DefaultCredentials
            client.Headers.Add(HttpRequestHeader.ContentType, "text/json")
            Dim response As String = client.UploadString(theUri, "test")
            ' WriteMessageToDiagnosticsLog returns the string "Success" as its result.
            AddStatus("Response:", response)

        Catch ex As Exception
            ' Possible exception causes: authorization failed, host not reachable, etc.
            AddStatus("ERROR: ", ex.Message)
        End Try

    End Sub

    Private Sub Button_GetIssueId_Click(sender As Object, e As EventArgs) Handles Button_GetIssueId.Click
        Dim client As WebClient = New WebClient()
        Dim queryString As String = $"?type={TextBox_issueTypeDesc.Text}&eid={TextBox_issueentityid.Text}&desc={TextBox_issueDesc.Text}&code={TextBox_issueCode.Text}"
        ExecuteGetRequest("issueid", queryString)

    End Sub

    Private Sub Button_FindIssues_Click(sender As Object, e As EventArgs) Handles Button_FindIssues.Click
        Dim client As WebClient = New WebClient()
        Dim queryString As String = $"?type={TextBox_FindIssuesType.Text}&eid={TextBox_FindIssuesEntityID.Text}&desc={TextBox_FindIssuesDesc.Text}&code={TextBox_FindIssuesCode.Text}"
        ExecuteGetRequest("issues", queryString)
    End Sub

    Private Sub Button_FindParts_Click(sender As Object, e As EventArgs) Handles Button_FindParts.Click
        Dim client As WebClient = New WebClient()
        Dim snParam As String = ""

        If Not String.IsNullOrWhiteSpace(TextBox_FindPartsSerialNumber.Text) Then
            snParam = $"&sn={TextBox_FindPartsSerialNumber.Text}"
        End If
        Dim queryString As String = $"?eid={TextBox_FindPartsEntityID.Text}&name={TextBox_FindPartsName.Text}&number={TextBox_FindPartsNumber.Text}{snParam}"
        ExecuteGetRequest("parts", queryString)
    End Sub

    Private Sub Button_GetIncident_Click(sender As Object, e As EventArgs) Handles Button_GetIncident.Click
        Dim client As WebClient = New WebClient()
        ' the /incident method requires eid, plus one of displayid OR (dettypid and detval)
        Dim dispIdQuery As String = ""
        Dim detailQuery As String = ""

        If String.IsNullOrWhiteSpace(TextBox_GetIncidentDispId.Text) AndAlso
            (String.IsNullOrWhiteSpace(TextBox_DetailTypeId.Text) AndAlso String.IsNullOrWhiteSpace(TextBox_DetailValue.Text)) Then
            AddStatus("ERROR:", "Missing required fields. Enter either display id OR (detail type id AND detail value)")
            Return
        End If

        If Not String.IsNullOrWhiteSpace(TextBox_GetIncidentDispId.Text) Then
            dispIdQuery = $"&displayid={TextBox_GetIncidentDispId.Text}"
        End If

        If Not (String.IsNullOrWhiteSpace(TextBox_DetailTypeId.Text) AndAlso String.IsNullOrWhiteSpace(TextBox_DetailValue.Text)) Then
            detailQuery = $"&dettypid={TextBox_DetailTypeId.Text}&detval={TextBox_DetailValue.Text}"
        End If

        Dim queryString As String = $"?eid={TextBox_GetIncidentEntityID.Text}{dispIdQuery}{detailQuery}"
        ExecuteGetRequest("incident", queryString)
    End Sub

    Private Sub Button_GetImportStatus_Click(sender As Object, e As EventArgs) Handles Button_GetImportStatus.Click
        Dim client As WebClient = New WebClient()
        Dim includeImportLogParam As String = ""
        Dim includeErrorLogParam As String = ""

        If CheckBox_ImportStatusInclImpLog.Checked Then
            includeImportLogParam = "&inclog=1"
        End If
        If CheckBox_ImportStatusIncError.Checked Then
            includeErrorLogParam = "&incerr=1"
        End If

        Dim queryString As String = $"?eid={TextBox_ImportStatusEntityId.Text}&name={TextBox_FindPartsName.Text}&id={TextBox_ImportStatusId.Text}{includeImportLogParam}{includeErrorLogParam}"
        ExecuteGetRequest("importstatus", queryString)
    End Sub

End Class
